% Table_5.m
% 
% forecast decomposition by driver
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions/');
addpath('Utilities/')
addpath('Data/')


% -- Options -- %
options = optimset('Display','off');
disp_code = 0;  % not displaying convergence every iteration

% -- Load Data and Draws -- %
load([matdir 'process_draws'], ...
    'tfp_proj_os_draws', 'eta_x_proj_os_draws', 'eta_m_proj_os_draws', ...
    'varphi_proj_os_draws', 'psi_proj_os_draws', 'Theta_t_proj_os_draws',...
    'rho_proj_os_draws');

T_is = 72;
% n_h = 20;
% T = T_is + n_h;

% tfp_proj_os_draws = tfp_proj_os_draws(1:T,:,:);
% eta_x_proj_os_draws = eta_x_proj_os_draws(1:T,:,:);
% eta_m_proj_os_draws = eta_m_proj_os_draws(1:T,:,:);
% varphi_proj_os_draws = varphi_proj_os_draws(1:T,:,:);
% psi_proj_os_draws = psi_proj_os_draws(1:T,:,:);
% Theta_t_proj_os_draws = Theta_t_proj_os_draws(1:T,:,:);
% rho_proj_os_draws = rho_proj_os_draws(1:T,:,:);

[T,n,ndraws]   = size(tfp_proj_os_draws);

va_share_forecast  = NaN(n,ndraws,6);
retcode_list    = NaN(ndraws,6);

for decomp_type = 1:6
    
    % for nn = 1:ndraws
    parfor nn = 1:ndraws
        fprintf('%3i %5i \n',[decomp_type nn]);
        % disp(nn);
        %  tic
    
        model_output    = load([matdir 'model_output']);
        py_lambda_guess = [model_output.py_model(T_is,:) model_output.lambdac_model(T_is)];
    
        % -- Setting Up Model Parameters and Driving Processes -- %
        model = model_setup(T_is);
        ind1_inv = model.ind1_inv;
        ind1_mat = model.ind1_mat;        
 
        if decomp_type == 1
            model.Theta_c(5)            = Theta_t_proj_os_draws(T,1,nn);
            trend_psi                   = psi_proj_os_draws(T,:,nn);
            trend_tfp                   = exp(tfp_proj_os_draws(T,:,nn));
            varphi                      = exp(varphi_proj_os_draws(T,:,nn));
            rho                         = rho_proj_os_draws(T,1,nn);
            eta_x                       = eta_x_proj_os_draws(T,:,nn);
            model.eta_x(ind1_inv(1),:)  = exp(eta_x)./(1+exp(eta_x));      
            model.eta_x(ind1_inv(2),:)  = 1-exp(eta_x)./(1+exp(eta_x));  
            eta_m                       = eta_m_proj_os_draws(T,:,nn);
            model.eta_m(ind1_mat(1),:)  = exp(eta_m)./(1+exp(eta_m));          
            model.eta_m(ind1_mat(2),:)  = 1-exp(eta_m)./(1+exp(eta_m));     
            decomp_name                 = 'full';
        elseif decomp_type == 2
            model.Theta_c(5)            = Theta_t_proj_os_draws(T_is,1,nn); %#ok<*PFBNS>
            trend_psi                   = psi_proj_os_draws(T_is,:,nn);
            trend_tfp                   = exp(tfp_proj_os_draws(T,:,nn));
            varphi                      = exp(varphi_proj_os_draws(T_is,:,nn));
            rho                         = rho_proj_os_draws(T_is,1,nn);
            eta_x                       = eta_x_proj_os_draws(T_is,:,nn);
            model.eta_x(ind1_inv(1),:)  = exp(eta_x)./(1+exp(eta_x));      
            model.eta_x(ind1_inv(2),:)  = 1-exp(eta_x)./(1+exp(eta_x));  
            eta_m                       = eta_m_proj_os_draws(T_is,:,nn);
            model.eta_m(ind1_mat(1),:)  = exp(eta_m)./(1+exp(eta_m));          
            model.eta_m(ind1_mat(2),:)  = 1-exp(eta_m)./(1+exp(eta_m));     
            decomp_name                 = 'tfp';
       elseif decomp_type == 3 
            model.Theta_c(5)            = Theta_t_proj_os_draws(T_is,1,nn);
            trend_psi                   = psi_proj_os_draws(T_is,:,nn);
            trend_tfp                   = exp(tfp_proj_os_draws(T_is,:,nn));
            varphi                      = exp(varphi_proj_os_draws(T_is,:,nn));
            rho                         = rho_proj_os_draws(T_is,1,nn);
            eta_x                       = eta_x_proj_os_draws(T,:,nn);
            model.eta_x(ind1_inv(1),:)  = exp(eta_x)./(1+exp(eta_x));      
            model.eta_x(ind1_inv(2),:)  = 1-exp(eta_x)./(1+exp(eta_x));  
            eta_m                       = eta_m_proj_os_draws(T,:,nn);
            model.eta_m(ind1_mat(1),:)  = exp(eta_m)./(1+exp(eta_m));          
            model.eta_m(ind1_mat(2),:)  = 1-exp(eta_m)./(1+exp(eta_m));           
            decomp_name                 = 'ibtc';
        elseif decomp_type == 4
            model.Theta_c(5)            = Theta_t_proj_os_draws(T,1,nn);
            trend_psi                   = psi_proj_os_draws(T_is,:,nn);
            trend_tfp                   = exp(tfp_proj_os_draws(T_is,:,nn));
            varphi                      = exp(varphi_proj_os_draws(T_is,:,nn));
            rho                         = rho_proj_os_draws(T,1,nn);
            eta_x                       = eta_x_proj_os_draws(T_is,:,nn);
            model.eta_x(ind1_inv(1),:)  = exp(eta_x)./(1+exp(eta_x));      
            model.eta_x(ind1_inv(2),:)  = 1-exp(eta_x)./(1+exp(eta_x));  
            eta_m                       = eta_m_proj_os_draws(T_is,:,nn);
            model.eta_m(ind1_mat(1),:)  = exp(eta_m)./(1+exp(eta_m));          
            model.eta_m(ind1_mat(2),:)  = 1-exp(eta_m)./(1+exp(eta_m));     
            decomp_name                 = 'pref';
        elseif decomp_type == 5
            model.Theta_c(5)            = Theta_t_proj_os_draws(T_is,1,nn);
            trend_psi                   = psi_proj_os_draws(T_is,:,nn);
            trend_tfp                   = exp(tfp_proj_os_draws(T_is,:,nn));
            varphi                      = exp(varphi_proj_os_draws(T,:,nn));
            rho                         = rho_proj_os_draws(T_is,1,nn);
            eta_x                       = eta_x_proj_os_draws(T_is,:,nn);
            model.eta_x(ind1_inv(1),:)  = exp(eta_x)./(1+exp(eta_x));      
            model.eta_x(ind1_inv(2),:)  = 1-exp(eta_x)./(1+exp(eta_x));  
            eta_m                       = eta_m_proj_os_draws(T_is,:,nn);
            model.eta_m(ind1_mat(1),:)  = exp(eta_m)./(1+exp(eta_m));          
            model.eta_m(ind1_mat(2),:)  = 1-exp(eta_m)./(1+exp(eta_m));     
            decomp_name                 = 'labor';
        elseif decomp_type == 6
            model.Theta_c(5)            = Theta_t_proj_os_draws(T_is,1,nn);
            trend_psi                   = psi_proj_os_draws(T,:,nn);
            trend_tfp                   = exp(tfp_proj_os_draws(T_is,:,nn));
            varphi                      = exp(varphi_proj_os_draws(T_is,:,nn));
            rho                         = rho_proj_os_draws(T_is,1,nn);
            eta_x                       = eta_x_proj_os_draws(T_is,:,nn);
            model.eta_x(ind1_inv(1),:)  = exp(eta_x)./(1+exp(eta_x));      
            model.eta_x(ind1_inv(2),:)  = 1-exp(eta_x)./(1+exp(eta_x));  
            eta_m                       = eta_m_proj_os_draws(T_is,:,nn);
            model.eta_m(ind1_mat(1),:)  = exp(eta_m)./(1+exp(eta_m));          
            model.eta_m(ind1_mat(2),:)  = 1-exp(eta_m)./(1+exp(eta_m));     
            decomp_name                 = 'psi';
        end

        % -- Solve for the Equilibrium -- % 
        try
            [equilibrium,retcode] = fcn_steps_solver_endolabor(varphi',rho,disp_code,py_lambda_guess',trend_tfp',trend_psi',model);
            retcode_list(nn,decomp_type) = retcode;
                
    
            % -- Outputs from procedure -- %
            py      = equilibrium.py;
            pv      = equilibrium.pv;
            px      = equilibrium.px;
            pm      = equilibrium.pm;
            y       = equilibrium.y;
            v       = equilibrium.v;
            xij     = equilibrium.xij;
            x       = equilibrium.x;
            mij     = equilibrium.mij;
            m       = equilibrium.m;
            c       = equilibrium.c;
            e       = equilibrium.e;
            psi     = equilibrium.psi;
            z       = equilibrium.z;
            varphi  = equilibrium.varphi;
            lambdac = equilibrium.lambdac;
            rho     = equilibrium.rho;
        
            % -- Model Consistency Checks -- %
            % disp('Model Consistency Checks:')
            ind1_inv    = model.ind1_inv;
            ind2_inv    = model.ind2_inv;
            eta_x       = model.eta_x;
            epsilon_x   = model.epsilon_x;
            rho_x       = model.rho_x;
            zeta_x      = model.zeta_x;
            ind1_mat    = model.ind1_mat;
            ind2_mat    = model.ind2_mat;
            eta_m       = model.eta_m;
            epsilon_m   = model.epsilon_m;
            rho_m       = model.rho_m;
            zeta_m      = model.zeta_m;
            gamma_y     = model.gamma_y;
            beta        = model.beta;
            delta       = model.delta;
            alpha       = model.alpha;
            s_c         = model.s_c;
            ind1_c      = model.ind1_c;
            ind2_c      = model.ind2_c;
            zeta_c      = model.zeta_c;
            Theta_c     = model.Theta_c;
            epsilon_c   = model.epsilon_c;
            sigma       = model.sigma;
            gamma_l     = model.gamma_l;
        
            
            % -- Investment Input Shares -- %
            inv_input_shares_model          = NaN(n,n);
            Omega_model_direct              = NaN(n,n);
            for j = 1:n
                for i = 1:n
                    Omega_model_direct(i,j) = py(i)*xij(i,j)/px(j)/x(j);
                end
                for i = ind1_inv
                    xkj = sum(eta_x(ind1_inv,j).*xij(ind1_inv,j).^((epsilon_x(j)-1)/epsilon_x(j))).^(epsilon_x(j)/(epsilon_x(j)-1));
                    inv_input_shares_model(i,j)  = xkj^((1-epsilon_x(j))/epsilon_x(j))*xij(i,j)^((epsilon_x(j)-1)/epsilon_x(j))*eta_x(i,j)*rho_x(j);
                end
                for i = ind2_inv
                    inv_input_shares_model(i,j)  = zeta_x(i,j)*(1-rho_x(j));
                end
            end
            inv_share_check = norm(inv_input_shares_model-Omega_model_direct);    
            % disp(['Investment Shares = ' num2str(inv_share_check)])
            % if inv_share_check > 1e-6
            %     warning('Inaccuracy in Investment Shares')
            %     pause;
            % end
        
        
            % -- Material Input Shares -- %
            mat_input_shares_model          = NaN(n,n);
            Phi_model_direct                = NaN(n,n);
            for j = 1:n
                for i = 1:n
                    Phi_model_direct(i,j) = py(i)*mij(i,j)/pm(j)/m(j);
                end
                for i = ind1_mat
                    mkj = sum(eta_m(ind1_mat,j).*mij(ind1_mat,j).^((epsilon_m(j)-1)/epsilon_m(j))).^(epsilon_m(j)/(epsilon_m(j)-1));
                    mat_input_shares_model(i,j)  = mkj^((1-epsilon_m(j))/epsilon_m(j))*mij(i,j)^((epsilon_m(j)-1)/epsilon_m(j))*eta_m(i,j)*rho_m(j);
                end
                for i = ind2_mat
                    mat_input_shares_model(i,j)  = zeta_m(i,j)*(1-rho_m(j));
                end
            end
            mat_share_check = norm(mat_input_shares_model-Phi_model_direct);    
            % disp(['Material Shares = ' num2str(mat_share_check)])
            % if mat_share_check > 1e-6
            %     warning('Inaccuracy in Material Shares')
            %     pause;
            % end
            
            
            % -- Value Added Shares -- %
            va_shares_model         = NaN(n,1);
            gamma_model_direct  = NaN(n,1);
            for j = 1:n
                gamma_model_direct(j) = pv(j)*v(j)/py(j)/y(j);
            end
            for j = 1:n
                va_shares_model(j)  = gamma_y(j);
            end
            va_share_check = norm(va_shares_model-gamma_model_direct);    
            % disp(['Value Added Shares in Gross Output = ' num2str(va_share_check)])
            % if va_share_check > 1e-6
            %     warning('Inaccuracy in Value Added Shares in Gross Output')
            %     pause;
            % end
        
            
            % -- Value Added Shares -- %
            con_shares_model         = NaN(n,1);
            theta_model_direct  = NaN(n,1);
            for j = 1:n
                theta_model_direct(j) = py(j)*c(j)/e;
            end
            for j = ind1_c
                con_shares_model(j) = zeta_c(j)*s_c;
            end
            omegac = zeros(n,1);
            for j = ind2_c(2:end)
                pyb = py(ind2_c(1));        % 
                En = sum(py(ind2_c).*c(ind2_c));
                fun = @(omega) Theta_c(j)*(py(j)/pyb)^(1-sigma)*(En/pyb)^((1-sigma)*(epsilon_c(j)-1))*(1-omega)^(epsilon_c(j)) - omega;
                omegac(j) = fsolve(fun,.2,options);
                con_shares_model(j) = omegac(j)*(1-s_c);
            end
            
            for j = ind2_c(1)
                omegac(j) = 1 - sum(omegac);
                con_shares_model(j) = omegac(j)*(1-s_c);
            end
            con_share_check = norm(con_shares_model-theta_model_direct);    
            % disp(['Consumption Shares = ' num2str(con_share_check)])
            % if con_share_check > 1e-6
                %warning('Inaccuracy in Consumption Shares')
                %pause;
            % end
        
            % Government and Net Exports
            psix_model_direct   = px.*x./(pv.*v);
                
            % Value Added Shares
            eta_psi = ((eye(n) - Phi_model_direct*(eye(n)-diag(gamma_model_direct)))*inv(diag(gamma_model_direct)) - Omega_model_direct*diag(psix_model_direct)   - diag(psi))\theta_model_direct; %#ok<*MINV>
            va_shares_model_psi = (eta_psi/sum(eta_psi))*100;
    
        
        
            % save model values
            va_share_forecast(:,nn,decomp_type) = va_shares_model_psi/100;
        
            py_lambda_guess = [py' lambdac];
        catch
            retcode_list(nn,decomp_type) = 0;
        end
    end
end

save([matdir 'forecasting_model.mat'])




% -- Table -- %

load([matdir 'model_output'],'va_share_model')


va_share_temp = va_share_forecast(:,retcode_list(:,1)==1,1);
va_share_delta = va_share_temp - va_share_model(T_is,:)';
delta_med = 100*prctile(va_share_delta',50);
delta_low = 100*prctile(va_share_delta',17);
delta_up  = 100*prctile(va_share_delta',83);


fid = fopen('Tables/Table_5.csv','w');
fprintf(fid,'Change 2018-2038, Model,');
fprintf(fid,'%8.1f,',delta_med);
fprintf(fid,'\n');
fprintf(fid,'68 Percent PI,');
for i = 1:5
    fprintf(fid,'%8.1f  %8.1f,',[delta_low(i),delta_up(i)]);
end
fprintf(fid,'\n');
fprintf(fid,'\n');

for ii = 2:6
    va_share_temp = va_share_forecast(:,retcode_list(:,ii)==1,ii);
    va_share_delta = va_share_temp - va_share_model(T_is,:)';
    delta_med = 100*prctile(va_share_delta',50);
    fprintf(fid,' ,');
    fprintf(fid,'%8.1f,',delta_med);
    fprintf(fid,'\n');
end
fclose(fid);